 ; CR - Circle Repair - make an arc into a circle or fix a trimmed ellipse.
 ; Copyright 1993, 2008, 2010 by Rocket Software Ltd.
 ; One Orion ship could put up a beautiful space station.
 (DEFUN C:CR (/ *error* snapp entt enam radi cenn layy arccol arclt circ modd
                                                                circol circlt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make the new local error handler, turn off snap.                      
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
  (setq entt (entget (setq enam (car (entsel)))))
  (cond ((= (cdr (assoc 0 entt)) "ARC")
         (setq radi (cdr (assoc 40 entt)))
         (setq cenn (cdr (assoc 10 entt)))
         (setq layy (assoc 8 entt))                  ; arc layer
         (setq arccol (assoc 62 entt))               ; arc colour
         (setq arclt (assoc 6 entt))                 ; arc linetype
         (entdel enam)                               ; delete arc
         (command "circle" cenn radi)                ; make circle
         (setq circ (entget (entlast)))              ; get circle data
         (if (not (equal layy (assoc 8 circ)))       ; if not on correct layer
             (progn
                 (setq circ (subst layy (assoc 8 circ) circ))
                 (setq modd T)))
         (setq circol (assoc 62 circ))
         (setq circlt (assoc 6 circ))
         (cond ((and arccol circol (not (equal arccol circol)))
                (setq circ (subst arccol circol circ))
                (setq modd T))
               ((and arccol (null circol))
                (setq circ (append circ (list arccol)))
                (setq modd T)))
         (cond ((and arclt circlt (not (equal arclt circlt)))
                (setq circ (subst arclt circlt circ))
                (setq modd T))
               ((and arclt (null circlt))
                (setq circ (append circ (list arclt)))
                (setq modd T)))
         (if modd (entmod circ))
         (if (and circlt (null arclt))
             (command "change" "l" "" "p" "lt" "bylayer" ""))
         (if (and circol (null arccol))
             (command "change" "l" "" "p" "c" "bylayer" "")))
        ((= (cdr (assoc 0 entt)) "ELLIPSE")
         (setq entt (subst (cons 41 0) (assoc 41 entt) entt))
         (entmod (subst (cons 42 (* 2 pi)) (assoc 42 entt) entt)))
        (t
         (write-line "\nThat was neither an arc nor an ellipse")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))